/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.gui.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.zurrtum.create.client.catnip.gui.render.BlockTransformRenderKey;
import com.zurrtum.create.client.catnip.gui.render.BlockTransformRenderState;
import com.zurrtum.create.client.catnip.gui.render.GpuTexture;
import com.zurrtum.create.client.flywheel.lib.model.baked.SinglePosVirtualBlockGetter;
import java.util.IdentityHashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11239;
import net.minecraft.class_11241;
import net.minecraft.class_11246;
import net.minecraft.class_11515;
import net.minecraft.class_12137;
import net.minecraft.class_12249;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2459;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_4722;
import net.minecraft.class_7833;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class BlockTransformElementRenderer
extends class_11239<BlockTransformRenderState> {
    private static final Map<BlockTransformRenderKey, GpuTexture> TEXTURES = new IdentityHashMap<BlockTransformRenderKey, GpuTexture>();
    private final class_4587 matrices = new class_4587();
    private int windowScaleFactor;

    public BlockTransformElementRenderer(class_4597.class_4598 vertexConsumers) {
        super(vertexConsumers);
    }

    public static void clear(BlockTransformRenderKey key) {
        GpuTexture texture = TEXTURES.remove(key);
        if (texture != null) {
            texture.close();
        }
    }

    public void prepare(BlockTransformRenderState block, class_11246 state, int windowScaleFactor) {
        BlockTransformRenderKey key;
        GpuTexture texture;
        if (this.windowScaleFactor != windowScaleFactor) {
            this.windowScaleFactor = windowScaleFactor;
            TEXTURES.values().forEach(GpuTexture::close);
            TEXTURES.clear();
        }
        if ((texture = TEXTURES.get(key = block.key())) == null || key.dirty) {
            float size = key.size * (float)windowScaleFactor;
            if (key.dirty) {
                key.dirty = false;
                if (texture != null && (float)texture.width() != size) {
                    texture.close();
                    texture = null;
                }
            }
            if (texture == null) {
                texture = GpuTexture.create((int)size);
                TEXTURES.put(key, texture);
            }
            texture.prepare(this.field_60042);
            this.matrices.method_22903();
            this.matrices.method_46416(size / 2.0f, size / 2.0f, 0.0f);
            if (key.padding != 0) {
                size -= (float)(key.padding * windowScaleFactor);
            }
            this.matrices.method_22905(size, size, size);
            if (key.zRot != 0.0f) {
                this.matrices.method_22907((Quaternionfc)class_7833.field_40718.rotation(key.zRot));
            }
            if (key.xRot != 0.0f) {
                this.matrices.method_22907((Quaternionfc)class_7833.field_40714.rotation(key.xRot));
            }
            if (key.yRot != 0.0f) {
                this.matrices.method_22907((Quaternionfc)class_7833.field_40716.rotation(key.yRot));
            }
            this.matrices.method_22905(1.0f, -1.0f, 1.0f);
            this.matrices.method_46416(-0.5f, -0.5f, -0.5f);
            class_310 mc = class_310.method_1551();
            class_1921 layer = key.state.method_27852(class_2246.field_10523) && (Boolean)key.state.method_11654((class_2769)class_2459.field_11446) != false ? class_12249.method_75972() : (class_4696.method_23679((class_2680)key.state) == class_11515.field_60926 ? class_4722.method_29382() : class_4722.method_24074());
            SinglePosVirtualBlockGetter world = SinglePosVirtualBlockGetter.createFullBright();
            world.blockState(key.state);
            mc.method_1541().method_3355(key.state, class_2338.field_10980, (class_1920)world, this.matrices, this.field_59933.method_73477(layer), false, key.parts);
            this.field_59933.method_22993();
            this.matrices.method_22909();
            texture.clear();
        }
        state.method_71996(new class_11241(class_10799.field_59968, class_11231.method_70900((GpuTextureView)texture.textureView(), (class_12137)RenderSystem.getSamplerCache().method_75297(FilterMode.NEAREST)), block.method_72127(), block.comp_4122(), block.comp_4123(), block.comp_4124(), block.comp_4125(), 0.0f, 1.0f, 1.0f, 0.0f, -1, block.comp_4128(), null));
    }

    protected void renderToTexture(BlockTransformRenderState block, class_4587 matrices) {
    }

    protected String method_70906() {
        return "Block Transform";
    }

    public Class<BlockTransformRenderState> method_70903() {
        return BlockTransformRenderState.class;
    }
}

